<?php

namespace Modules\Tax\Business;

use Illuminate\Database\Eloquent\Model;

class ItemSale extends Model 
{

    protected $table = 'item_sales';
    public $timestamps = true;

    public function items()
    {
        return $this->morphToMany('Item', 'itemable', 'itemables', 'itemable_id', 'item_id')->withPivot('itemable_type')->wherePivot('itemable_type', self::class);
    }

    public function item_tax_schema()
    {
        return $this->belongsTo('ItemTaxSchema');
    }

    public function item_withholding_tax_schema()
    {
        return $this->belongsTo('ItemWithholdingTaxSchema');
    }

}